<?php
// declare the output of the file as CSS
header('Content-type: text/css');
?>
#header {
<?php

$exts = array('jpg');

//collect list of images in current (look) directory
//modification suggested by Kaf Oseo
$url = array();
if($handle = opendir(dirname(__FILE__))) {
        while(false !== ($image = readdir($handle)))
                foreach($exts as $ext)
                        if(strstr($image, '.' . $ext))
                                $url[] = $image;
        closedir($handle);
}

//generate a random number
srand((double)microtime() * 1000000);

// number of images
$ct = count($url);

// random image number
$rn = (rand()%$ct);

// get the image name
$imgname = trim($url[$rn]);

// create a working image 
$im = imagecreatefromjpeg($imgname);

$width = imagesx($im);
$height = imagesy($im);

$upperx = floor($width / 3);
$lowerx = floor(2 * ($width / 3));
$midx = floor($width / 2);

$lefty = floor($height / 3);
$righty = floor(2 * ($height / 3));
$midy = floor($height / 2);

// sample five points in the image, based on rule of thirds and center
$rgb = array();

$rgb[1] = imagecolorat($im, $upperx, $lefty);
$rgb[2] = imagecolorat($im, $lowerx, $lefty);
$rgb[3] = imagecolorat($im, $upperx, $righty);
$rgb[4] = imagecolorat($im, $lowerx, $righty); 
$rgb[5] = imagecolorat($im, $midx, $midy);

// extract each value for r, g, b
$r = array();
$g = array();
$b = array();

for ($i = 1; $i <= 5; $i++) {
   $r[$i] = ($rgb[$i] >> 16) & 0xFF;
   $g[$i] = ($rgb[$i] >> 8) & 0xFF;
   $b[$i] = $rgb[$i] & 0xFF;
   }

printf("background-image: URL('%s');\n", $imgname);
echo "width: " . $width . "px; height: " . $height . "px;";

?>
           background-repeat: no-repeat; 
           background-position: top left;
}

<?php
   printf(".color1 { fill: rgb($r[1],$g[1],$b[1]); stroke: rgb($r[4],$g[4],$b[4]); }\n");
   printf(".color2 { fill: rgb($r[2],$g[2],$b[2]); stroke: rgb($r[3],$g[3],$b[3]); }\n");
   printf(".color3 { fill: rgb($r[3],$g[3],$b[3]); stroke: rgb($r[2],$g[2],$b[2]); }\n");
   printf(".color4 { fill: rgb($r[4],$g[4],$b[4]); stroke: rgb($r[1],$g[1],$b[1]); }\n");
   printf(".color5 { fill: rgb($r[5],$g[5],$b[5]); }\n");
 
   printf("stop.begin { stop-color: rgb($r[1],$g[1],$b[1]); }\n");
   printf("stop.middle   { stop-color: rgb($r[5],$g[5],$b[5]); }\n");
   printf("stop.end { stop-color: rgb($r[4],$g[4],$b[4]); }\n"); 
   printf(" h2 { color: rgb($r[4],$g[4],$b[4]); } \n");

?>
